//=============================================================================
// EquipSlotWindowActorChange.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/07/17 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 装備スロットウィンドウ アクター切り替え
 * @target MZ
 * @author くろあめ
 *
 * @help
 * スキルスロットウィンドウでの操作中に
 * Q/Wキーによるアクター切り替えができるようになります。
 * 
 * アクターを切り替えた後、選択カーソルは
 * 一番上のスロットに強制遷移します
 * これは、アクターごとにスロット数が異なる状況を作りうる
 * 各種プラグインへの対応となります。
 * 
 * ついでに、シフトキーの押下で
 * 今選択されているスロットの装備を解除する機能を追加します。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {


// スロットウィンドウのL/R切り替え対応 装備解除ボタン実装対応

Window_EquipSlot.prototype.processHandling = function() {
    if (this.isOpenAndActive()) {
        if (this.isOkEnabled() && this.isOkTriggered()) {
            return this.processOk();
        }
        if (this.isCancelEnabled() && this.isCancelTriggered()) {
            return this.processCancel();
        }
        if (this.isHandled("pagedown") && Input.isTriggered("pagedown")) {
            return this.processPagedown();
        }
        if (this.isHandled("pageup") && Input.isTriggered("pageup")) {
            return this.processPageup();
        }
        if (this.isHandled("shift") && Input.isTriggered("shift")) {
            return this.processShift();
        }
    }
};

Window_EquipSlot.prototype.processShift = function() {
    this.updateInputData();
    this.deactivate();
    this.callHandler("shift");
};

Scene_Equip.prototype.createSlotWindow = function() {
    const rect = this.slotWindowRect();
    this._slotWindow = new Window_EquipSlot(rect);
    this._slotWindow.setHelpWindow(this._helpWindow);
    this._slotWindow.setStatusWindow(this._statusWindow);
    this._slotWindow.setHandler("ok", this.onSlotOk.bind(this));
    this._slotWindow.setHandler("cancel", this.onSlotCancel.bind(this));
    this._slotWindow.setHandler("pagedown", this.nextActorSlot.bind(this));
    this._slotWindow.setHandler("pageup", this.previousActorSlot.bind(this));
    this._slotWindow.setHandler("shift", this.removeEquipCommand.bind(this));

    this.addWindow(this._slotWindow);
};

Scene_Equip.prototype.onActorChangeSlot = function() {
    Scene_MenuBase.prototype.onActorChange.call(this);
    this.refreshActor();
    this.hideItemWindow();
    this._commandWindow.deselect();
    this._commandWindow.deactivate();
    this._slotWindow.select(0);
    this._slotWindow.activate();
};

Scene_MenuBase.prototype.nextActorSlot = function() {
    $gameParty.makeMenuActorNext();
    this.updateActor();
    this.onActorChangeSlot();
};

Scene_MenuBase.prototype.previousActorSlot = function() {
    $gameParty.makeMenuActorPrevious();
    this.updateActor();
    this.onActorChangeSlot();
};

Scene_Equip.prototype.removeEquipCommand = function() {
    const actor = this.actor();
    const slotId = this._slotWindow.index();
    if(slotId == 0){
        SoundManager.playBuzzer();
    }else{
        SoundManager.playEquip();
        actor.changeEquip(slotId, null);
    }
    this._itemWindow.refresh();
    this._statusWindow.refresh();
    this._slotWindow.select(slotId);
    this._slotWindow.refresh();
    this._slotWindow.activate();
};

})();

